/*****************************************************************************
 * Phone Activation Server
 *****************************************************************************
 * Copyright (C) 2007 Jon Lech Johansen <jon@nanocr.eu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Collections.Generic;
using System.Security.Cryptography;

namespace PhoneActSrv
{
    public class Server
    {
        private readonly int port;
        private readonly IPAddress address;
        private TcpListener listener;

        public Server( IPAddress address, int port )
        {
            this.port = port;
            this.address = address;
        }

        public void Start()
        {
            listener = new TcpListener( address, port );
            listener.Start();

            Thread thread = new Thread( new ThreadStart( StartListen ) );
            thread.Start();
        }

        public void Stop()
        {
            listener.Stop();
        }

        private void StartListen()
        {
            try
            {
                while( true )
                {
                    Socket socket = listener.AcceptSocket();
                    socket.Blocking = true;

                    if( socket.Connected )
                    {
                        ActProcessor processor = new ActProcessor( socket );
                        Thread thread = new Thread( new ThreadStart( processor.Process ) );
                        thread.Start();
                    }
                }
            }
            catch( SocketException /*ex*/ )
            {
                //Console.WriteLine( "SocketException: {0}", ex );
            }
        }
    }

    public class ActProcessor
    {
        private Socket socket;

        private byte[] actrecord = new byte[]
        {
            0x00 // REPLACE WITH VALID ACTIVATION RECORD
        };

        private byte[] showcfg = new byte[]
        {
0x3C,0x3F,0x78,0x6D,0x6C,0x20,0x76,0x65,0x72,0x73,0x69,0x6F,
0x6E,0x3D,0x22,0x31,0x2E,0x30,0x22,0x20,0x65,0x6E,0x63,0x6F,
0x64,0x69,0x6E,0x67,0x3D,0x22,0x55,0x54,0x46,0x2D,0x38,0x22,
0x20,0x73,0x74,0x61,0x6E,0x64,0x61,0x6C,0x6F,0x6E,0x65,0x3D,
0x22,0x6E,0x6F,0x22,0x3F,0x3E,0x0A,0x3C,0x44,0x6F,0x63,0x75,
0x6D,0x65,0x6E,0x74,0x20,0x78,0x6D,0x6C,0x6E,0x73,0x3D,0x22,
0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x77,0x77,0x77,0x2E,0x61,
0x70,0x70,0x6C,0x65,0x2E,0x63,0x6F,0x6D,0x2F,0x69,0x74,0x6D,
0x73,0x2F,0x22,0x20,0x64,0x69,0x73,0x61,0x62,0x6C,0x65,0x48,
0x69,0x73,0x74,0x6F,0x72,0x79,0x3D,0x22,0x74,0x72,0x75,0x65,
0x22,0x20,0x64,0x69,0x73,0x61,0x62,0x6C,0x65,0x4E,0x61,0x76,
0x69,0x67,0x61,0x74,0x69,0x6F,0x6E,0x3D,0x22,0x74,0x72,0x75,
0x65,0x22,0x3E,0x20,0x20,0x20,0x20,0x20,0x20,0x0A,0x0A,0x3C,
0x50,0x72,0x6F,0x74,0x6F,0x63,0x6F,0x6C,0x3E,0x0A,0x20,0x20,
0x20,0x20,0x3C,0x70,0x6C,0x69,0x73,0x74,0x20,0x76,0x65,0x72,
0x73,0x69,0x6F,0x6E,0x3D,0x22,0x31,0x2E,0x30,0x22,0x3E,0x0A,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3C,0x64,0x69,0x63,
0x74,0x3E,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x0A,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3C,0x6B,0x65,0x79,
0x3E,0x69,0x70,0x68,0x6F,0x6E,0x65,0x2D,0x61,0x63,0x74,0x69,
0x76,0x61,0x74,0x69,0x6F,0x6E,0x3C,0x2F,0x6B,0x65,0x79,0x3E,
0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3C,
0x64,0x69,0x63,0x74,0x3E,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x3C,0x6B,0x65,0x79,0x3E,0x61,
0x63,0x6B,0x2D,0x72,0x65,0x63,0x65,0x69,0x76,0x65,0x64,0x3C,
0x2F,0x6B,0x65,0x79,0x3E,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x3C,0x74,0x72,0x75,0x65,0x2F,
0x3E,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x3C,0x6B,0x65,0x79,0x3E,0x73,0x68,
0x6F,0x77,0x2D,0x73,0x65,0x74,0x74,0x69,0x6E,0x67,0x73,0x3C,
0x2F,0x6B,0x65,0x79,0x3E,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3C,0x74,0x72,0x75,
0x65,0x2F,0x3E,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x20,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
0x20,0x20,0x20,0x3C,0x2F,0x64,0x69,0x63,0x74,0x3E,0x0A,0x20,
0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x0A,0x20,0x20,0x20,0x20,
0x0A,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3C,0x2F,
0x64,0x69,0x63,0x74,0x3E,0x0A,0x20,0x20,0x20,0x20,0x3C,0x2F,
0x70,0x6C,0x69,0x73,0x74,0x3E,0x0A,0x3C,0x2F,0x50,0x72,0x6F,
0x74,0x6F,0x63,0x6F,0x6C,0x3E,0x0A,0x0A,0x3C,0x2F,0x44,0x6F,
0x63,0x75,0x6D,0x65,0x6E,0x74,0x3E,0x0A,
        };

        public ActProcessor(Socket socket)
        {
            this.socket = socket;
        }

        public void Process()
        {
            try
            {
                byte[] retdata;
                string actstate;
                string httpver = "HTTP/1.1";

                try
                {
                    int pos, si, ei;
                    byte[] data = new byte[1024 * 10];
                    int i = socket.Receive(data, data.Length, 0);

                    string buf = Encoding.ASCII.GetString(data, 0, i);

                    pos = buf.IndexOf("HTTP", 1);
                    httpver = buf.Substring(pos, 8);

                    pos = buf.IndexOf("\r");
                    string[] tks = buf.Substring(0, pos).Split(new char[] { ' ' });

                    pos = buf.IndexOf("ActivationInfoXML");
                    si = buf.IndexOf("<data>", pos) + 6;
                    ei = buf.IndexOf("</data>", pos);
                    string actxml = buf.Substring(si, ei - si);
                    actxml = Encoding.ASCII.GetString(Convert.FromBase64String(actxml));
                    pos = actxml.IndexOf("ActivationState");
                    si = actxml.IndexOf("<string>", pos) + 8;
                    ei = actxml.IndexOf("</string>", pos);
                    actstate = actxml.Substring(si, ei - si);
                }
                catch (Exception /*e*/)
                {
                    actstate = "Activated";
                }
                
                if (actstate.Equals("Unactivated"))
                {
                    retdata = actrecord;
                }
                else
                {
                    retdata = showcfg;
                }               

                string header = String.Empty;
                header += httpver + " 200" + "\r\n";
                header += "Server: albert.apple.com\r\n";
                header += "Content-Type: text/xml\r\n";
                header += "Content-Length: " + retdata.Length.ToString() + "\r\n\r\n";

                byte[] sd = Encoding.ASCII.GetBytes(header);
                socket.Send(sd);
                socket.Send(retdata);
                socket.Close();
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
    }
}