/*****************************************************************************
 * Phone Activation Server
 *****************************************************************************
 * Copyright (C) 2007 Jon Lech Johansen <jon@nanocr.eu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net;

namespace PhoneActSrv
{
    public partial class PhoneActSrv : Form
    {
        private Server srv;

        public PhoneActSrv()
        {
            InitializeComponent();
        }

        private void WebAddr_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("http://nanocr.eu");
        }

        private void Email_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Process.Start("mailto:jon@nanocr.eu");
        }

        private void PhoneActSrv_Load(object sender, EventArgs e)
        {
            try
            {
                srv = new Server(IPAddress.Loopback, 80);
                srv.Start();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Phone Activation Server Error");
                Application.Exit();
            }
        }

        protected override void OnFormClosed(FormClosedEventArgs e)
        {
 	        base.OnFormClosed(e);
            
            try
            {
                srv.Stop();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Phone Activation Server Error");
            }
        }
    }
}